<?php

if (!defined('ABSPATH')) {
    exit;
}


add_action('wp_ajax_nopriv_digits_social_login', 'digits_ajax_social_login');


function digits_ajax_social_login()
{
    if (empty($_REQUEST['oauth'])) {
        return;
    }

    if (is_user_logged_in()) {
        return;
    }
    $oauth_key = $_REQUEST['oauth'];

    $social_list = digits_socials_list();

    if (empty($social_list[$oauth_key])) {
        return;
    }

    $social_settings = get_option('digits_option_social_settings');

    if (empty($social_settings)) {
        return;
    }


    $social_setting = $social_settings[$oauth_key];

    if (!empty($social_setting['enable']) && $social_setting['enable'] == 1) {
        $social_info = $social_list[$oauth_key];
        $loader = $social_info['loader'];
        $class = "Digits\SocialLogin\Auths\\$loader";
        $load = new $class($social_setting, $social_info, false);
        $load->process_oauth_token();
    }

}

function digits_url_social_login()
{
    if (empty($_SERVER['REQUEST_URI'])) {
        return;
    }
    $request_uri = $_SERVER['REQUEST_URI'];

    $callback_prefix = '/social-login/redirect/';

    if (strpos($request_uri, $callback_prefix) !== 0) {
        return;
    }

    $request_uri = str_replace($callback_prefix, '', $request_uri);
    $request_uri = explode("?", $request_uri, 2);

    if (sizeof($request_uri) == 2) {
        $_REQUEST['oauth'] = $request_uri[0];
        digits_ajax_social_login();
        die();
    }
}

add_action('init', 'digits_url_social_login');